package ru.yandex.calendar.frontend.caldav.proto.tree;

import org.apache.jackrabbit.webdav.DavResource;
import org.apache.jackrabbit.webdav.DavResourceIterator;
import org.apache.jackrabbit.webdav.DavResourceIteratorImpl;
import org.apache.jackrabbit.webdav.property.DavPropertySet;
import org.apache.jackrabbit.webdav.property.DefaultDavProperty;
import org.apache.jackrabbit.webdav.property.ResourceType;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.calendar.frontend.caldav.proto.webdav.WebdavConstants;
import ru.yandex.inside.passport.PassportUid;

/**
 * @author Stepan Koltsov
 *
 * @see CaldavResourceUserRoot
 */
public class CarddavResourceUserRoot extends CarddavResourceUserBase {

    public CarddavResourceUserRoot(CaldavRequestContext caldavContext, String user, PassportUid passportUid) {
        super(caldavContext, user, passportUid);
    }

    @Override
    public boolean isCollection() {
        return true;
    }

    @Override
    public String getHref() {
        return CalendarUrls.addressbooksUser(user).getEncoded();
    }

    @Override
    public DavResourceIterator getMembers() {
        return new DavResourceIteratorImpl(Cf.<DavResource>list(new CarddavResourceUserAddressbook(caldavRequestContext, user, passportUid)));
    }

    @Override
    public DavPropertySet getProperties() {
        DavPropertySet ps = new DavPropertySet();
        ps.add(new ResourceType(new int[] { ResourceType.COLLECTION }));
        ps.add(new DefaultDavProperty<>(WebdavConstants.DAV_DISPLAYNAME_PROP, getUserName()));
        return ps;
    }

} //~
