package ru.yandex.calendar.frontend.caldav.proto.tree;

import java.io.IOException;

import org.apache.jackrabbit.webdav.DavException;
import org.apache.jackrabbit.webdav.WebdavRequest;
import org.apache.jackrabbit.webdav.WebdavResponse;
import org.apache.jackrabbit.webdav.property.DavPropertySet;
import org.apache.jackrabbit.webdav.property.DefaultDavProperty;
import org.apache.jackrabbit.webdav.property.ResourceType;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.calendar.frontend.caldav.proto.ClientHolder;
import ru.yandex.calendar.frontend.caldav.proto.caldav.CaldavConstants;
import ru.yandex.calendar.frontend.caldav.proto.jackrabbit.JackrabbitUtils;
import ru.yandex.calendar.frontend.caldav.proto.webdav.WebdavConstants;
import ru.yandex.calendar.frontend.caldav.proto.webdav.report.ReportRequest;
import ru.yandex.calendar.frontend.caldav.proto.webdav.report.ReportRequestParser;
import ru.yandex.calendar.frontend.caldav.proto.webdav.report.ReportRequestPrincipalPropertySearch;
import ru.yandex.calendar.frontend.caldav.proto.webdav.report.ReportRequestPrincipalSearchPropertySet;
import ru.yandex.calendar.frontend.caldav.proto.webdav.xml.MultiStatus2;
import ru.yandex.calendar.frontend.caldav.proto.webdav.xml.MultiStatusResponse2;
import ru.yandex.calendar.frontend.caldav.proto.webdav.xml.MultiStatusUtils;
import ru.yandex.calendar.frontend.caldav.proto.webdav.xml.PrincipalSearchProperty;
import ru.yandex.calendar.frontend.caldav.proto.webdav.xml.PrincipalSearchPropertySet;
import ru.yandex.calendar.frontend.caldav.proto.webdav.xml.PrincipalSearchPropertySetXmlizer;
import ru.yandex.misc.web.servlet.HttpServletResponseX;

/**
 * @author Stepan Koltsov
 */
public class CcResourcePrincipals extends CaldavResourceBase {
    public CcResourcePrincipals(CaldavRequestContext caldavContext) {
        super(caldavContext);
    }

    @Override
    public String getHref() {
        return CalendarUrls.principals().getEncoded();
    }

    @Override
    public DavPropertySet getProperties() {
        DavPropertySet ps = new DavPropertySet();
        ps.add(new ResourceType(new int[] { ResourceType.COLLECTION }));
        ps.add(new DefaultDavProperty<String>(WebdavConstants.DAV_GETETAG_PROP, "never-changes"));
        ps.addAll(caldavContext.getGlobalProperties());
        return ps;
    }

    @Override
    public void report(WebdavRequest request, WebdavResponse response) throws DavException, IOException {
        ReportRequest reportRequest = ReportRequestParser.parse(request.getRequestDocument().getDocumentElement());
        if (reportRequest instanceof ReportRequestPrincipalSearchPropertySet) {
            PrincipalSearchPropertySet r = new PrincipalSearchPropertySet(Cf.list(
                    new PrincipalSearchProperty(WebdavConstants.DAV_DISPLAYNAME_PROP, "Display Name"),
                    new PrincipalSearchProperty(CaldavConstants.CALENDARSERVER_EMAIL_ADDRESS_SET_PROP, "Email Addresses"),
                    new PrincipalSearchProperty(CaldavConstants.CALENDARSERVER_LAST_NAME_PROP, "Last Name"),
                    new PrincipalSearchProperty(CaldavConstants.CALENDARSERVER_FIRST_NAME_PROP, "First Name"),
                    new PrincipalSearchProperty(CaldavConstants.CALDAV_CALENDAR_USER_TYPE_PROP, "Calendar User Type"),
                    new PrincipalSearchProperty(CaldavConstants.CALDAV_CALENDAR_USER_ADDRESS_SET_PROP, "Calendar User Address Set")
                ));
            byte[] xmlBytes = PrincipalSearchPropertySetXmlizer.S.serializeXml(r);
            HttpServletResponseX.wrap(response).writeContent(xmlBytes, "text/xml; charset=utf-8");
        } else if (reportRequest instanceof ReportRequestPrincipalPropertySearch) {
            ReportRequestPrincipalPropertySearch search = (ReportRequestPrincipalPropertySearch) reportRequest;

            ListF<MultiStatusResponse2> responses = ClientHolder.getScope().includesContacts()
                    ? ccCalendarFacade.findUsers(search, ClientHolder.getPassportUid(), caldavRequestContext.getUserAgentType())
                    : Cf.list();
            MultiStatus2 ms = new MultiStatus2(responses);

            MultiStatusUtils.sendMultiStatus(ms, request, response, getMeterRegistry());
        } else {
            response.sendError(JackrabbitUtils.supportedReportError());
        }
    }

} //~
