package ru.yandex.calendar.frontend.caldav.proto.tree;

import java.io.IOException;

import org.apache.jackrabbit.webdav.DavException;
import org.apache.jackrabbit.webdav.DavResource;
import org.apache.jackrabbit.webdav.WebdavRequest;
import org.apache.jackrabbit.webdav.WebdavResponse;
import org.apache.jackrabbit.webdav.property.DavPropertySet;

import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;

/**
 * @author Stepan Koltsov
 *
 * XXX: should be /principals/users/stepancheg@yandex-team.ru/ not /principals/stepancheg@yandex-team.ru/
 */
public class CcResourcePrincipalsUser extends CaldavResourceBase {
    private static final Logger logger = LoggerFactory.getLogger(CcResourcePrincipalsUser.class);

    private final String user;

    public CcResourcePrincipalsUser(CaldavRequestContext caldavContext, String user) {
        super(caldavContext);
        this.user = user;
    }

    @Override
    public DavResource getCollection() {
        return new CcResourcePrincipals(caldavRequestContext);
    }

    @Override
    public String getHref() {
        return CalendarUrls.principals(user).getEncoded();
    }

    protected String getUserName() {
        try {
            return ccCalendarFacade.getUserName(user);
        } catch (Exception e) {
            logger.warn("Failed to get user name", e);
            return "Unknown";
        }
    }

    @Override
    public DavPropertySet getProperties() {
        return caldavContext.getPrincipalUrlProperties(user);
    }

    @Override
    public boolean isAccessibleTo(String client) {
        return ccCalendarFacade.isUserResourcesAccessibleToClient(user, client);
    }

    @Override
    public void report(WebdavRequest request0, WebdavResponse response) throws DavException, IOException {
        caldavContext.report(user, request0, response);
    }

} //~
