package ru.yandex.calendar.frontend.caldav.proto.tree;

import org.apache.jackrabbit.webdav.DavResourceIterator;
import org.apache.jackrabbit.webdav.DavResourceIteratorImpl;
import org.apache.jackrabbit.webdav.property.DavPropertySet;

/**
 * @author Stepan Koltsov
 */
public class CcResourceRoot extends CaldavResourceBase {

    public CcResourceRoot(CaldavRequestContext caldavContext) {
        super(caldavContext);
    }

    @Override
    public boolean isCollection() {
        return true;
    }

    @Override
    public String getHref() {
        return CalendarUrls.root();
    }

    @Override
    public DavResourceIterator getMembers() {
        // XXX: incorrect, must return principals, calendars etc.
        return DavResourceIteratorImpl.EMPTY;
    }

    @Override
    public DavPropertySet getProperties() {
        DavPropertySet ps = new DavPropertySet();
        //ps.add(new HrefProperty(WebdavConstants.DAV_PRINCIPAL_COLLECTION_SET_PROP, CalendarUrls.user(ClientHolder.get()), false));
        ps.addAll(caldavContext.getGlobalProperties());
        return ps;
    }

} //~
