package ru.yandex.calendar.frontend.caldav.proto.tree;

import ru.yandex.inside.passport.PassportUid;
import ru.yandex.misc.lang.DefaultObject;

/**
 * @author Daniel Brylev
 */
public abstract class CollectionId extends DefaultObject {

    private final String user; // URL part
    private final String id;
    private final PassportUid passportUid;

    private CollectionId(String user, String id, PassportUid passportUid) {
        this.user = user;
        this.id = id;
        this.passportUid = passportUid;
    }

    public static CollectionId events(String user, String id, PassportUid passportUid) {
        return new Events(user, id, passportUid);
    }

    public static CollectionId todos(String user, String id, PassportUid passportUid) {
        return new Todos(user, id, passportUid);
    }

    public static CollectionId unknown(String user, String id, PassportUid passportUid) {
        return new Unknown(user, id, passportUid);
    }

    public String getUser() {
        return user;
    }

    public String getId() {
        return id;
    }

    public PassportUid getPassportUid() {
        return passportUid;
    }

    public boolean isEvents() {
        return this instanceof Events;
    }

    public boolean isTodos() {
        return this instanceof Todos;
    }

    public boolean isUnknown() {
        return this instanceof Unknown;
    }

    private static class Events extends CollectionId {
        private Events(String user, String id, PassportUid passportUid) {
            super(user, id, passportUid);
        }
    }

    private static class Todos extends CollectionId {
        private Todos(String user, String id, PassportUid passportUid) {
            super(user, id, passportUid);
        }
    }

    private static class Unknown extends CollectionId {
        private Unknown(String user, String id, PassportUid passportUid) {
            super(user, id, passportUid);
        }
    }

}
