package ru.yandex.calendar.frontend.caldav.proto.tree;

import org.apache.jackrabbit.webdav.property.DavProperty;
import org.apache.jackrabbit.webdav.property.DavPropertyName;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;

/**
 * @author Stepan Koltsov
 */
public abstract class PropertiesCollectionBase implements PropertiesCollection {

    @Override
    public DavProperty<?> getProperty(DavPropertyName name) {
        return getProperties().get(name);
    }

    @Override
    public DavPropertyName[] getPropertyNames() {
        return getProperties().getPropertyNames();
    }

    @Override
    public ListF<DavPropertyName> getPropertyNamesList() {
        return Cf.x(getPropertyNames());
    }

} //~
