package ru.yandex.calendar.frontend.caldav.proto.tree;

import java.io.IOException;

import org.apache.jackrabbit.webdav.DavException;
import org.apache.jackrabbit.webdav.DavResource;
import org.apache.jackrabbit.webdav.WebdavRequest;
import org.apache.jackrabbit.webdav.WebdavResponse;
import org.apache.jackrabbit.webdav.io.InputContext;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.calendar.frontend.caldav.proto.PutResponse;
import ru.yandex.calendar.frontend.caldav.proto.webdav.report.PropertiesRequest;
import ru.yandex.calendar.frontend.caldav.proto.webdav.xml.MultiStatus2;

/**
 * Extended version of {@link DavResource}
 * @author Stepan Koltsov
 */
public interface WebdavResource extends DavResource, PropertiesCollection {
    boolean hasCustomGet();
    void get(WebdavRequest request, WebdavResponse response) throws DavException, IOException;

    PutResponse put(WebdavResource resource, InputContext inputContext) throws DavException;
    void post(WebdavRequest request, WebdavResponse response) throws DavException, IOException;
    void report(WebdavRequest request, WebdavResponse response) throws DavException, IOException;

    MultiStatus2 propFind(PropertiesRequest propertiesRequest, int depth) throws DavException, IOException;

    boolean isAccessibleTo(String client);

    ListF<WebdavResource> getMembersList();
} //~
