package ru.yandex.calendar.frontend.caldav.proto.webdav;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.function.Function;
import ru.yandex.misc.bender.annotation.GlobalPartName;
import ru.yandex.misc.bender.annotation.XmlText;
import ru.yandex.misc.io.http.UrlUtils;
import ru.yandex.misc.lang.DefaultObject;
import ru.yandex.misc.lang.Validate;
import ru.yandex.misc.regex.Pattern2;

/**
 * @author Stepan Koltsov
 */
@GlobalPartName(name=WebdavConstants.DAV_HREF_NAME, namespace=WebdavConstants.DAV_NS_URI)
public class DavHref extends DefaultObject {
    @XmlText
    private final String href;

    protected DavHref(String href) {
        Validate.notEmpty(href);
        this.href = href;
    }

    public static DavHref fromEncoded(String href) {
        return new DavHref(href);
    }

    public static DavHref fromDecoded(String href) {
        return new DavHref(encodeUri(href));
    }

    public String getEncoded() {
        return href;
    }

    public String getDecoded() {
        return UrlUtils.urlDecode(href);
    }

    @Override
    public String toString() {
        return href;
    }

    public DavHref addDecodedChild(String decodedChild) {
        String decodedThis = this.getDecoded();

        if (decodedThis.endsWith("/")) {
            return DavHref.fromDecoded(decodedThis + decodedChild);
        } else {
            return DavHref.fromDecoded(decodedThis + "/" + decodedChild);
        }
    }

    public static Function<DavHref, String> getDecodedF() {
        return new Function<DavHref, String>() {
            public String apply(DavHref href) {
                return href.getDecoded();
            }
        };
    }

    public static Function<DavHref, String> getEncodedF() {
        return new Function<DavHref, String>() {
            public String apply(DavHref href) {
                return href.getEncoded();
            }
        };
    }

    private static String encodeUri(String uri) {
        Validate.V.isTrue(uri.startsWith("/"));
        ListF<String> separatedPath = Pattern2.compile("/+").split(uri).filter(Cf.String.notEmptyF()).map(new Function<String, String>() {
            public String apply(String s) {
                return UrlUtils.urlEncode(s);
            }
        });
        if (separatedPath.isNotEmpty() && uri.endsWith("/")) {
            return "/" + separatedPath.mkString("/") + "/";
        } else {
            return "/" + separatedPath.mkString("/");
        }
    }

} //~
