package ru.yandex.calendar.frontend.caldav.proto.webdav;

import java.util.Optional;

import lombok.Value;
import org.joda.time.Instant;

/**
 * This class contains info specified in the token value of {@link DavSyncToken}.
 * The reason for this class existing is the fact that {@link DavSyncToken} is
 * a DTO class used for XML requests and responses, and therefore it is
 * risky to have those fields inside it.
 */
@Value
public class DavSyncInfo {
    long millis;
    Optional<String> externalId;

    public Instant getInstant() {
        return new Instant(millis);
    }
}
