package ru.yandex.calendar.frontend.caldav.proto.webdav;

/**
 * @author Daniel Brylev
 *
 * @url http://tools.ietf.org/html/rfc6578#section-6.3
 *
 *    <!ELEMENT sync-level CDATA>
 *
 *    <!-- Text MUST be either "1" or "infinite" -->
 *
 */
public enum DavSyncLevel {
    ONE("1"),
    INFINITE("infinite"),
    ;

    private final String value;

    private DavSyncLevel(String value) {
        this.value = value;
    }

    public String getValue() {
        return value;
    }

    public static DavSyncLevel fromValue(String value) {
        for (DavSyncLevel level : values()) {
            if (value.equals(level.getValue())) {
                return level;
            }
        }
        throw new IllegalArgumentException("unexpected sync-level " + value);
    }

    @Override
    public String toString() {
        return getValue();
    }
}
