package ru.yandex.calendar.frontend.caldav.proto.webdav;

import lombok.EqualsAndHashCode;

import ru.yandex.misc.bender.annotation.GlobalPartName;
import ru.yandex.misc.bender.annotation.XmlText;
import ru.yandex.misc.lang.Check;

@GlobalPartName(name = WebdavConstants.DAV_SYNC_TOKEN_NAME, namespace = WebdavConstants.DAV_NS_URI)
@EqualsAndHashCode(doNotUseGetters = true)
public class DavSyncToken {
    // empty in initial sync request
    // http://tools.ietf.org/html/rfc6578#section-3.8
    @XmlText
    private final String value;

    public DavSyncToken(String value) {
        this.value = value;
    }

    public boolean isEmpty() {
        return value.isEmpty();
    }

    public String getValue() {
        Check.isFalse(isEmpty(), "sync-token is empty!");
        return value;
    }

    @Override
    public String toString() {
        if (isEmpty()) {
            return "[empty sync-token]";
        } else {
            return value;
        }
    }

}
