package ru.yandex.calendar.frontend.caldav.proto.webdav;

import org.apache.http.HttpStatus;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.MapF;

public class HttpReasonPhrases {

    private static MapF<Integer, String> statusPhrases = Cf.hashMap();
    static {
        statusPhrases.put(100, "Continue");
        statusPhrases.put(101, "Switching Protocols");
        statusPhrases.put(200, "OK");
        statusPhrases.put(201, "Created");
        statusPhrases.put(202, "Accepted");
        statusPhrases.put(203, "Non-Authoritative Information");
        statusPhrases.put(204, "No Content");
        statusPhrases.put(205, "Reset Content");
        statusPhrases.put(206, "Partial Content");
        statusPhrases.put(300, "Multiple Choices");
        statusPhrases.put(301, "Moved Permanently");
        statusPhrases.put(302, "Found");
        statusPhrases.put(303, "See Other");
        statusPhrases.put(304, "Not Modified");
        statusPhrases.put(305, "Use Proxy");
        statusPhrases.put(307, "Temporary Redirect");
        statusPhrases.put(400, "Bad Request");
        statusPhrases.put(401, "Unauthorized");
        statusPhrases.put(402, "Payment Required");
        statusPhrases.put(403, "Forbidden");
        statusPhrases.put(404, "Not Found");
        statusPhrases.put(405, "Method Not Allowed");
        statusPhrases.put(406, "Not Acceptable");
        statusPhrases.put(407, "Proxy Authentication Required");
        statusPhrases.put(408, "Request Time-out");
        statusPhrases.put(409, "Conflict");
        statusPhrases.put(410, "Gone");
        statusPhrases.put(411, "Length Required");
        statusPhrases.put(412, "Precondition Failed");
        statusPhrases.put(413, "Request Entity Too Large");
        statusPhrases.put(414, "Request-URI Too Large");
        statusPhrases.put(415, "Unsupported Media Type");
        statusPhrases.put(416, "Requested range not satisfiable");
        statusPhrases.put(417, "Expectation Failed");
        statusPhrases.put(500, "Internal Server Error");
        statusPhrases.put(501, "Not Implemented");
        statusPhrases.put(502, "Bad Gateway");
        statusPhrases.put(503, "Service Unavailable");
        statusPhrases.put(504, "Gateway Time-out");
        statusPhrases.put(505, "HTTP Version not supported");
        statusPhrases.put(HttpStatus.SC_INSUFFICIENT_STORAGE, "Insufficient Storage");
    }

    public static String getReasonPhrase(int status) {
        return statusPhrases.getOrThrow(status);
    }

}
