package ru.yandex.calendar.frontend.caldav.proto.webdav;

import org.apache.jackrabbit.webdav.DavConstants;
import org.apache.jackrabbit.webdav.property.DavPropertyName;
import org.apache.jackrabbit.webdav.property.ResourceType;
import org.apache.jackrabbit.webdav.security.SecurityConstants;
import org.apache.jackrabbit.webdav.xml.Namespace;
import org.dom4j.QName;

import ru.yandex.calendar.frontend.caldav.proto.caldav.CaldavConstants;
import ru.yandex.misc.xml.dom4j.Dom4jUtils;

/**
 * @see DavConstants
 * @see CaldavConstants
 */
public class WebdavConstants {

    public static final String DAV_NS_URI = "DAV:";
    public static final Namespace DAV_NS = DavConstants.NAMESPACE;

    public static final String DAV_HREF_NAME =                          "href";
    public static final String DAV_PROP_NAME =                          "prop";
    public static final String DAV_PROPSTAT_NAME =                      "propstat";
    public static final String DAV_ALLPROP_NAME =                       "allprop";
    public static final String DAV_PROPNAME_NAME =                      "propname";
    public static final String DAV_MULTISTATUS_NAME =                   "multistatus";
    public static final String DAV_STATUS_NAME =                        "status";
    public static final String DAV_EXPAND_PROPERTY_NAME =               "expand-property";
    public static final String DAV_PROPERTY_NAME =                      "property";
    public static final String DAV_RESPONSE_NAME =                      "response";
    public static final String DAV_RESPONSEDESCRIPTION_NAME =           "responsedescription";
    public static final String DAV_DESCRIPTION_NAME =                   "description";
    public static final String DAV_PRINCIPAL_SEARCH_PROPERTY_NAME =     "principal-search-property";
    public static final String DAV_PRINCIPAL_SEARCH_PROPERTY_SET_NAME = "principal-search-property-set";
    public static final String DAV_PROPERTY_SEARCH_NAME =               "property-search";
    public static final String DAV_SYNC_TOKEN_NAME =                    "sync-token";

    private static DavPropertyName createProperty(String name) {
        return DavPropertyName.create(name, DAV_NS);
    }

    private static QName createQName(String name) {
        return Dom4jUtils.createQName(name, DAV_NS.getPrefix(), DAV_NS.getURI());
    }

    public static final DavPropertyName DAV_DISPLAYNAME_PROP =                createProperty("displayname");
    public static final DavPropertyName DAV_PRINCIPAL_URL_PROP =              createProperty("principal-URL");
    public static final DavPropertyName DAV_GETETAG_PROP =                    createProperty("getetag");
    public static final DavPropertyName DAV_RESOURCETYPE_PROP =               createProperty("resourcetype");
    public static final DavPropertyName DAV_GETCONTENTTYPE_PROP =             createProperty("getcontenttype");
    public static final DavPropertyName DAV_PRINCIPAL_COLLECTION_SET_PROP =   createProperty("principal-collection-set");
    public static final DavPropertyName DAV_OWNER_PROP =                      createProperty("owner");
    public static final DavPropertyName DAV_SUPPORTED_REPORT_SET_PROP =       createProperty("supported-report-set");
    public static final DavPropertyName DAV_CURRENT_USER_PRINCIPAL_PROP =     createProperty("current-user-principal");
    public static final DavPropertyName DAV_CURRENT_USER_PRIVILEGE_SET_PROP = createProperty("current-user-privilege-set");
    // http://tools.ietf.org/html/rfc6578#section-4
    public static final DavPropertyName DAV_SYNC_TOKEN_PROP =                 createProperty(DAV_SYNC_TOKEN_NAME);

    public static final int DAV_COLLECTION_RT = ResourceType.COLLECTION;

    public static final int DAV_PRINCIPAL_RT  = SecurityConstants.PRINCIPAL_RESOURCETYPE;

    public static final QName DAV_HREF_QNAME =                   createQName("href");
    public static final QName DAV_PROP_QNAME =                   createQName("prop");
    public static final QName DAV_PROPSTAT_QNAME =               createQName("propstat");
    public static final QName DAV_ALLPROP_QNAME =                createQName("allprop");
    public static final QName DAV_PROPNAME_QNAME =               createQName("propname");
    public static final QName DAV_MULTISTATUS_QNAME =            createQName("multistatus");
    public static final QName DAV_STATUS_QNAME =                 createQName("status");
    public static final QName DAV_ERROR_QNAME =                  createQName("error");
    public static final QName DAV_LIMITS_MATCHES_QNAME =         createQName("number-of-matches-within-limits");
    public static final QName DAV_PROPERTY_QNAME =               createQName("property");
    public static final QName DAV_RESPONSE_QNAME =               createQName("response");
    public static final QName DAV_RESPONSEDESCRIPTION_QNAME =    createQName("responsedescription");

    public static final QName DAV_SUPPORTED_REPORT_QNAME =       createQName("supported-report");
    public static final QName DAV_REPORT_QNAME =                 createQName("report");

    public static final QName  DAV_ACL_PRINCIPAL_PROP_SET_QNAME =    createQName("acl-principal-prop-set");
    public static final QName  DAV_PRINCIPAL_MATCH_QNAME =           createQName("principal-match");
    public static final QName  DAV_PRINCIPAL_PROPERTY_SEARCH_QNAME = createQName("principal-property-search");
    public static final QName  DAV_EXPAND_PROPERTY_QNAME =           createQName("expand-property");
    public static final QName  DAV_SYNC_TOKEN_QNAME =                createQName(DAV_SYNC_TOKEN_NAME);
    public static final QName  DAV_LIMIT_QNAME =                     createQName("limit");
    public static final QName  DAV_NRESULTS_QNAME =                  createQName("nresults");

    // http://tools.ietf.org/html/rfc6578#section-3.2
    public static final QName  DAV_SYNC_COLLECTION_QNAME =           createQName("sync-collection");
    // http://tools.ietf.org/html/rfc6578#section-6.3
    public static final QName  DAV_SYNC_LEVEL_QNAME =                createQName("sync-level");

    public static final String DAV_ACCESS_CONTROL_DAV = "access-control"; // http://tools.ietf.org/html/rfc3744

}
