package ru.yandex.calendar.frontend.caldav.proto.webdav.report;

import ru.yandex.bolts.collection.Option;
import ru.yandex.calendar.frontend.caldav.proto.webdav.WebdavConstants;
import ru.yandex.misc.bender.annotation.GlobalPartName;
import ru.yandex.misc.bender.annotation.XmlAttribute;
import ru.yandex.misc.bender.annotation.XmlText;

/**
 * Seems like there is no specification for match.
 *
 * @author Stepan Koltsov
 * @see PropertySearch
 */
@GlobalPartName(name="match", namespace=WebdavConstants.DAV_NS_URI)
public class Match {

    @XmlText
    private final String text;
    @XmlAttribute(name="match-type")
    private final Option<String> matchType;

    public Match(String text, Option<String> matchType) {
        this.text = text;
        this.matchType = matchType;
    }

    public String getText() {
        return text;
    }

    public Option<String> getMatchType() {
        return matchType;
    }

} //~
