package ru.yandex.calendar.frontend.caldav.proto.webdav.report;

import ru.yandex.calendar.frontend.caldav.proto.webdav.WebdavConstants;
import ru.yandex.calendar.frontend.caldav.proto.webdav.xml.Prop;
import ru.yandex.misc.bender.annotation.BenderPart;
import ru.yandex.misc.bender.annotation.GlobalPartName;

/**
 * @author Stepan Koltsov
 *
 * <code>
 *  <!ELEMENT property-search (prop, match) >
 * </code>
 *
 * @see ReportRequestPrincipalPropertySearch
 */
@GlobalPartName(name=WebdavConstants.DAV_PROPERTY_SEARCH_NAME, namespace=WebdavConstants.DAV_NS_URI)
public class PropertySearch {

    @BenderPart
    private final Prop prop;
    @BenderPart
    private final Match match;

    public PropertySearch(Prop prop, Match match) {
        this.prop = prop;
        this.match = match;
    }

    public Prop getProp() {
        return prop;
    }

    public Match getMatch() {
        return match;
    }

} //~
