package ru.yandex.calendar.frontend.caldav.proto.webdav.report;

import org.w3c.dom.Element;

import ru.yandex.bolts.function.Function;
import ru.yandex.calendar.frontend.caldav.proto.webdav.WebdavConstants;
import ru.yandex.misc.lang.StringUtils;
import ru.yandex.misc.xml.dom.DomUtils;
import ru.yandex.misc.xml.dom4j.Dom4jUtils;

/**
 * @author Stepan Koltsov
 */
public class ReportRequestExpandPropertyParser {

    private static ReportRequestExpandPropertyProperty parseProperty(Element element) {
        DomUtils.validateName(element, Dom4jUtils.toJavaxXmlNamespaceQName(WebdavConstants.DAV_PROPERTY_QNAME));

        String name = element.getAttribute("name");
        String namespace = StringUtils.defaultIfEmpty(element.getAttribute("namespace"), WebdavConstants.DAV_NS.getURI());
        return new ReportRequestExpandPropertyProperty(name, namespace, DomUtils.childElements(element).map(parsrPropertyF()));
    }

    private static Function<Element, ReportRequestExpandPropertyProperty> parsrPropertyF() {
        return new Function<Element, ReportRequestExpandPropertyProperty>() {
            public ReportRequestExpandPropertyProperty apply(Element element) {
                return parseProperty(element);
            }
        };
    }

    public static ReportRequestExpandProperty parse(Element root) {
        DomUtils.validateName(root, Dom4jUtils.toJavaxXmlNamespaceQName(WebdavConstants.DAV_EXPAND_PROPERTY_QNAME));

        return new ReportRequestExpandProperty(DomUtils.childElements(root).map(parsrPropertyF()));
    }

} //~
