package ru.yandex.calendar.frontend.caldav.proto.webdav.report;

import org.apache.jackrabbit.webdav.property.DavPropertyName;
import org.apache.jackrabbit.webdav.property.DavPropertyNameSet;
import org.apache.jackrabbit.webdav.xml.Namespace;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.misc.lang.Validate;

/**
 * @author Stepan Koltsov
 */
public class ReportRequestExpandPropertyProperty {
    private final String name;
    private final String namespace;

    private final ListF<ReportRequestExpandPropertyProperty> children;

    public ReportRequestExpandPropertyProperty(String name, String namespace, ListF<ReportRequestExpandPropertyProperty> children) {
        Validate.notEmpty(name);
        Validate.notEmpty(namespace);

        this.name = name;
        this.namespace = namespace;
        this.children = children;
    }

    public boolean is(DavPropertyName davPropertyName) {
        return namespace.equals(davPropertyName.getNamespace().getURI()) && name.equals(davPropertyName.getName());
    }

    public String getName() {
        return name;
    }

    public String getNamespace() {
        return namespace;
    }

    public ListF<ReportRequestExpandPropertyProperty> getChildren() {
        return children;
    }

    public DavPropertyName toDavPropertyName() {
        return DavPropertyName.create(name, Namespace.getNamespace(namespace));
    }

    public DavPropertyNameSet toDavPropertyNameSetFromChildren() {
        DavPropertyNameSet r = new DavPropertyNameSet();
        for (ReportRequestExpandPropertyProperty prop : children) {
            r.add(prop.toDavPropertyName());
        }
        return r;
    }

} //~
