package ru.yandex.calendar.frontend.caldav.proto.webdav.report;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.calendar.frontend.caldav.proto.ccdav.AddressbookSearchOperator;
import ru.yandex.calendar.frontend.caldav.proto.webdav.WebdavConstants;
import ru.yandex.calendar.frontend.caldav.proto.webdav.xml.Prop;
import ru.yandex.calendar.logic.ics.iv5j.ical.parameter.IcsCuType;
import ru.yandex.misc.bender.annotation.BenderDefaultValue;
import ru.yandex.misc.bender.annotation.BenderPart;
import ru.yandex.misc.bender.annotation.BenderWrapper;
import ru.yandex.misc.bender.annotation.GlobalPartName;
import ru.yandex.misc.bender.annotation.XmlAttribute;

/**
 * @author Stepan Koltsov
 * @see ReportRequestPrincipalSearchPropertySet
 * @see ReportRequestPrincipalPropertySearchParserTest
 * @url http://wiki.yandex-team.ru/calendar/re/caldav/calendarserver/iCal/contacts
 * @url http://tools.ietf.org/html/rfc3744#section-9.4 (DAV:principal-property-search REPORT)
 * @url http://tools.ietf.org/html/rfc3744#section-9.4.2 (Example: successful DAV:principal-property-search REPORT
 *
 * <code>
 *  <!ELEMENT principal-property-search
 *   ((property-search+), prop?, apply-to-principal-collection-set?) >
 * </code>
 *
 */
@GlobalPartName(name="principal-property-search", namespace=WebdavConstants.DAV_NS_URI)
public class ReportRequestPrincipalPropertySearch extends ReportRequest {

    /**
     * <q>
     * Multiple property-search elements or multiple elements within a
     * DAV:prop element will be interpreted with a logical AND.
     * </q>
     */
    @BenderDefaultValue("allof")
    @XmlAttribute(name="test")
    private AddressbookSearchOperator operator;

    // @url http://wiki.yandex-team.ru/calendar/re/caldav/YandexCalendar/iCal/location
    @XmlAttribute(name="type")
    private Option<ReportRequestPrincipalPropertySearchType> type;

    // XXX: temp, must use gobal name
    @BenderPart(name=WebdavConstants.DAV_PROPERTY_SEARCH_NAME, namespace=WebdavConstants.DAV_NS_URI)
    private ListF<PropertySearch> propertySearches;

    // XXX: temp, must use gobal name
    @BenderPart(name=WebdavConstants.DAV_PROP_NAME, namespace=WebdavConstants.DAV_NS_URI)
    private Option<Prop> prop;

    public AddressbookSearchOperator getOperator() {
        return operator;
    }

    public ListF<PropertySearch> getPropertySearches() {
        return propertySearches;
    }

    public Option<Prop> getProp() {
        return prop;
    }

    public Option<ReportRequestPrincipalPropertySearchType> getType() {
        return type;
    }

    @BenderWrapper
    static class ReportRequestPrincipalPropertySearchType {
        private final String type;

        public ReportRequestPrincipalPropertySearchType(String type) {
            this.type = type;
        }

        public IcsCuType getType() {
            return IcsCuType.valueOf(type);
        }
    }

} //~
