package ru.yandex.calendar.frontend.caldav.proto.webdav.report;

import java.util.Set;

import org.apache.jackrabbit.webdav.property.AbstractDavProperty;
import org.apache.jackrabbit.webdav.xml.XmlSerializable;
import org.dom4j.QName;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.calendar.frontend.caldav.proto.webdav.WebdavConstants;

/**
 * <code>SupportedReportSetProperty</code> represents the DAV:supported-report-set
 * property defined by RFC 3253. It identifies the reports that are supported by
 * the given resource.
 * <pre>
 * &lt;!ELEMENT supported-report-set (supported-report*)&gt;
 * &lt;!ELEMENT supported-report report&gt;
 * &lt;!ELEMENT report ANY&gt;
 * ANY value: a report element type
 * </pre>
 *
 * @see {@link org.apache.jackrabbit.webdav.version.report.SupportedReportSetProperty}
 *
 * @author Daniel Brylev <dbrylev@yandex-team.ru>
 * @author gutman
 */
public class SupportedReportSetProperty extends AbstractDavProperty<Set<XmlSerializable>> {

    private final QName[] reports;

    public SupportedReportSetProperty(QName[] reports) {
        super(WebdavConstants.DAV_SUPPORTED_REPORT_SET_PROP, false);
        this.reports = reports;
    }

    @Override
    public Set<XmlSerializable> getValue() {
        Set<XmlSerializable> components = Cf.hashSet();

        for (final QName reportName : reports) {
            components.add(new XmlSerializable() {
                public Element toXml(Document document) {
                    Element supportedReportElement = emptyElement(document, WebdavConstants.DAV_SUPPORTED_REPORT_QNAME);
                    Element reportElement = emptyElement(document, WebdavConstants.DAV_REPORT_QNAME);
                    Element reportNameElement = emptyElement(document, reportName);
                    reportElement.appendChild(reportNameElement);
                    supportedReportElement.appendChild(reportElement);
                    return supportedReportElement;
                }
            });
        }
        return components;
    }

    private Element emptyElement(Document document, QName qname) {
        return document.createElementNS(qname.getNamespaceURI(), qname.getNamespacePrefix() + ":" + qname.getName());
    }

}
