package ru.yandex.calendar.frontend.caldav.proto.webdav.xml;

import java.util.List;
import java.util.Optional;

import org.dom4j.DocumentFactory;
import org.dom4j.Element;

import ru.yandex.calendar.frontend.caldav.proto.webdav.DavSyncToken;
import ru.yandex.calendar.frontend.caldav.proto.webdav.WebdavConstants;

/**
 * @url http://tools.ietf.org/html/rfc2518#section-12.9
 */
public class MultiStatus2 {
    private final List<MultiStatusResponse2> response2s;
    private final Optional<String> responseDescription;
    // http://tools.ietf.org/html/rfc6578#section-3.9
    private final Optional<DavSyncToken> syncToken;

    public MultiStatus2(List<MultiStatusResponse2> responses) {
        this(responses, Optional.empty(), Optional.empty());
    }

    public MultiStatus2(List<MultiStatusResponse2> response2s, Optional<String> responseDescription, Optional<DavSyncToken> syncToken) {
        this.response2s = response2s;
        this.responseDescription = responseDescription;
        this.syncToken = syncToken;
    }

    public MultiStatus2(List<MultiStatusResponse2> response2s, DavSyncToken syncToken) {
        this.response2s = response2s;
        this.responseDescription = Optional.empty();
        this.syncToken = Optional.of(syncToken);
    }

    @SuppressWarnings("unchecked")
    public Element toXml() {
        Element r = DocumentFactory.getInstance().createElement(WebdavConstants.DAV_MULTISTATUS_QNAME);
        for (MultiStatusResponse2 response2 : response2s) {
            r.content().add(response2.toXml());
        }
        responseDescription.ifPresent(s -> r.addElement(WebdavConstants.DAV_RESPONSEDESCRIPTION_QNAME).addText(s));
        syncToken.ifPresent(davSyncToken -> r.addElement(WebdavConstants.DAV_SYNC_TOKEN_QNAME).addText(davSyncToken.getValue()));
        return r;
    }

    public List<MultiStatusResponse2> getResponse2s() {
        return response2s;
    }
}
