package ru.yandex.calendar.frontend.caldav.proto.webdav.xml;

import java.util.Arrays;

import io.micrometer.core.instrument.MeterRegistry;
import lombok.SneakyThrows;
import lombok.val;
import org.apache.jackrabbit.webdav.MultiStatus;
import org.apache.jackrabbit.webdav.WebdavRequest;
import org.apache.jackrabbit.webdav.WebdavResponse;

import ru.yandex.calendar.frontend.caldav.impl.CaldavJackrabbitServlet;
import ru.yandex.misc.io.http.HttpStatus;
import ru.yandex.misc.web.servlet.HttpServletResponseX;
import ru.yandex.misc.xml.dom4j.Dom4jUtils;

public class MultiStatusUtils {
    public static void sendMultiStatus(MultiStatus2 ms, WebdavRequest request, WebdavResponse response, MeterRegistry registry) {
        val signal = CaldavJackrabbitServlet.getRequestSignal("application.request.caldav", request);
        ms.getResponse2s().stream().flatMap(v -> v.getStatuses().stream())
                .forEach(status -> registry.counter(signal + "." + status).increment());

        byte[] xmlBytes = Dom4jUtils.I.writeElementAsDocumentToBytes(ms.toXml());

        response.setStatus(HttpStatus.SC_207_MULTI_STATUS);
        HttpServletResponseX.wrap(response).writeContent(xmlBytes, "text/xml; charset=utf-8");
    }

    @SneakyThrows
    public static void sendMultiStatus(MultiStatus multiStatus, WebdavRequest request, WebdavResponse response, MeterRegistry registry) {
        val signal = CaldavJackrabbitServlet.getRequestSignal("application.request.caldav", request);
        Arrays.stream(multiStatus.getResponses()).flatMap(ms -> Arrays.stream(ms.getStatus()))
                .forEach(status -> registry.counter(signal + "." + status.getStatusCode()).increment());
        response.sendMultiStatus(multiStatus);
    }
}
