package ru.yandex.calendar.frontend.caldav.proto.webdav.xml;

import org.apache.jackrabbit.webdav.property.PropEntry;

import ru.yandex.calendar.frontend.caldav.proto.webdav.WebdavConstants;
import ru.yandex.misc.bender.annotation.BenderPart;
import ru.yandex.misc.bender.annotation.GlobalPartName;

/**
 * @author Stepan Koltsov
 * @see PrincipalSearchPropertySet
 */
@GlobalPartName(name=WebdavConstants.DAV_PRINCIPAL_SEARCH_PROPERTY_NAME, namespace=WebdavConstants.DAV_NS_URI)
public class PrincipalSearchProperty {

    @BenderPart
    private final Prop prop;

    // XXX: xml:lang='en' attribute
    @BenderPart(name=WebdavConstants.DAV_DESCRIPTION_NAME, namespace=WebdavConstants.DAV_NS_URI)
    private final String description;

    public PrincipalSearchProperty(Prop prop, String description) {
        this.prop = prop;
        this.description = description;
    }

    public PrincipalSearchProperty(PropEntry propEntry, String description) {
        this(new Prop(propEntry), description);
    }

} //~
