package ru.yandex.calendar.frontend.caldav.proto.webdav.xml;

import java.util.Collection;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;

import org.apache.jackrabbit.webdav.property.DavPropertyName;
import org.apache.jackrabbit.webdav.property.PropEntry;
import org.apache.jackrabbit.webdav.xml.DomUtil;
import org.apache.jackrabbit.webdav.xml.XmlSerializable;
import org.dom4j.DocumentFactory;
import org.dom4j.Element;
import org.dom4j.io.DOMReader;
import org.w3c.dom.Document;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.function.Function;
import ru.yandex.calendar.frontend.caldav.proto.webdav.WebdavConstants;
import ru.yandex.misc.ExceptionUtils;
import ru.yandex.misc.bender.annotation.BendingMethod;
import ru.yandex.misc.bender.annotation.GlobalPartName;
import ru.yandex.misc.bender.serialize.BenderXmlOrJsonWriter;
import ru.yandex.misc.lang.DefaultObject;
import ru.yandex.misc.xml.dom.DomUtils;
import ru.yandex.misc.xml.dom4j.Dom4jToXmlWriterWriter;

/**
 * @author Stepan Koltsov
 */
@GlobalPartName(name=WebdavConstants.DAV_PROP_NAME, namespace=WebdavConstants.DAV_NS_URI)
public class Prop extends DefaultObject {

    private final ListF<PropEntry> properties;

    @SuppressWarnings("unchecked")
    public Prop(Collection<? extends PropEntry> properties) {
        this.properties = (ListF<PropEntry>) Cf.x(properties).toList();
    }

    public Prop(PropEntry propEntry) {
        this(Cf.list(propEntry));
    }

    public ListF<PropEntry> getProperties() {
        return properties;
    }

    public ListF<DavPropertyName> getPropertyNames() {
        return properties.map(DavPropertyName.class::cast);
    }

    private static final DocumentBuilder DOCUMENT_BUILDER;
    static {
        try {
            DOCUMENT_BUILDER = DomUtil.BUILDER_FACTORY.newDocumentBuilder();
        } catch (ParserConfigurationException e) {
            throw ExceptionUtils.translate(e);
        }
    }

    // parser and serializers are lame
    public Element toDom4jXml() {
        Element r = DocumentFactory.getInstance().createElement(WebdavConstants.DAV_PROP_QNAME);

        for (PropEntry propEntry : properties) {
            XmlSerializable xmlSerializable = (XmlSerializable) propEntry;
            Document document = DOCUMENT_BUILDER.newDocument();
            document.appendChild(xmlSerializable.toXml(document));

            r.add(new DOMReader().read(document).getRootElement());
        }
        return r;
    }

    @BendingMethod
    public void serialize(BenderXmlOrJsonWriter w) {
        Dom4jToXmlWriterWriter dom4jToXmlWriterWriter = new Dom4jToXmlWriterWriter(w.getXml());
        dom4jToXmlWriterWriter.writeElement(toDom4jXml());
    }

    @BendingMethod
    public static Prop parse(org.w3c.dom.Element element) {
        return new Prop(DomUtils.childElements(element).map(new Function<org.w3c.dom.Element, DavPropertyName>() {
            public DavPropertyName apply(org.w3c.dom.Element element) {
                return DavPropertyName.createFromXml(element);
            }
        }));
    }

} //~
