package ru.yandex.calendar.frontend.caldav.proto.webdav.xml;

import org.dom4j.DocumentFactory;
import org.dom4j.Element;

import ru.yandex.bolts.collection.Option;
import ru.yandex.calendar.frontend.caldav.proto.webdav.WebdavConstants;
import ru.yandex.misc.bender.annotation.GlobalPartName;
import ru.yandex.misc.xml.dom4j.Dom4jUtils;

/**
 * @url http://tools.ietf.org/html/rfc2518#section-12.9.1.1
 */
@GlobalPartName(name=WebdavConstants.DAV_PROPSTAT_NAME, namespace=WebdavConstants.DAV_NS_URI)
public class PropStat {
    private final Prop prop;
    private final Status status;
    private final Option<ResponseDescription> responseDescription = Option.empty();

    public PropStat(Status status, Prop prop) {
        this.status = status;
        this.prop = prop;
    }

    public int getStatus() {
        return status.getStatus();
    }

    @SuppressWarnings("unchecked")
    public Element toXml() {
        // XXX: improve MagicXmlSerializer to avoid this
        Element r = DocumentFactory.getInstance().createElement(WebdavConstants.DAV_PROPSTAT_QNAME);
        r.add(prop.toDom4jXml());
        r.add(Dom4jUtils.readRootElement(WebdavXmlizers.statusXmlizer.serializeXml(status)));
        r.content().addAll(responseDescription.map(WebdavXmlizers.responseDescriptionXmlizer::serializeXml));
        return r;
    }
}
