package ru.yandex.calendar.frontend.caldav.proto.webdav.xml;

import ru.yandex.calendar.frontend.caldav.proto.webdav.WebdavConstants;
import ru.yandex.misc.bender.annotation.GlobalPartName;
import ru.yandex.misc.bender.annotation.XmlText;

@GlobalPartName(name=WebdavConstants.DAV_STATUS_NAME, namespace=WebdavConstants.DAV_NS_URI)
public class Status {
    @XmlText
    private final String line;
    private final int status;

    public Status(String line, int status) {
        this.line = line;
        this.status = status;
    }

    int getStatus() {
        return this.status;
    }

    public static final Status STATUS_200_OK = new Status("HTTP/1.1 200 OK", 200);
    public static final Status STATUS_404_NOT_FOUND = new Status("HTTP/1.1 404 Not Found", 404);

} //~
