package ru.yandex.calendar.frontend.caldav.userAgent;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

import lombok.experimental.UtilityClass;
import lombok.extern.slf4j.Slf4j;
import lombok.val;

@UtilityClass
@Slf4j
public class UserAgents {
    private static final Pattern IOS_PATTERN = Pattern.compile("^iOS/(\\d+)\\.(\\d+).*$");

    private boolean isGroupValueGE(Matcher matcher, int index, int value) {
        try {
            // We have to make this really safe so we do not change the behaviour by throwing 500 to the client
            return Integer.valueOf(matcher.group(index)) >= value;
        } catch (Exception e) {
            log.error("An error has occurred while matching IOS patterns", e);
            return false;
        }
    }

    public UserAgentType userAgentType(String userAgent) {
        if (userAgent.startsWith("ru.yandex.mail")) {
            return UserAgentType.YANDEX_MOBILE_MAIL_CLIENT;
        }

        if (userAgent.contains("Lightning")) {
            return UserAgentType.LIGHTNING;
        }

        if (userAgent.contains("iPhone")) {
            return UserAgentType.IPHONE;
        }

        val iOSMatcher = IOS_PATTERN.matcher(userAgent);

        if (iOSMatcher.matches()) {
            // TODO Does this really work? Here is a counter example: 9.0.
            return isGroupValueGE(iOSMatcher, 1, 8) && isGroupValueGE(iOSMatcher, 2, 1)
                    ? UserAgentType.IOS_8_1_AND_HIGHER
                    : UserAgentType.IOS_8_0_AND_LOWER;
        }

        if (userAgent.contains("iCal/") || userAgent.startsWith("Mac") && userAgent.contains("CalendarAgent/")) {
            return UserAgentType.ICAL;
        }

        if (userAgent.contains("Android")) {
            if (userAgent.contains("CalDAVSync")) {
                return UserAgentType.HYPERMATIX_ANDROID;
            }

            if (userAgent.contains("CalDAV-Sync")) {
                return UserAgentType.CALDAVSYNC_ANDROID;
            }

            if (userAgent.contains("CalDAV Sync Adapter")) {
                return UserAgentType.CALDAVSYNCADAPTER_ANDROID;
            }
        }

        if (userAgent.startsWith("DAVdroid")) {
            return UserAgentType.DAVDROID;
        }

        if (userAgent.startsWith("Apache-HttpClient/UNAVAILABLE")) {
            return UserAgentType.YANDEX_KIT;
        }

        if (userAgent.startsWith("Windows-Phone-WebDAV-Client")) {
            return UserAgentType.WINDOWS_PHONE;
        }

        return UserAgentType.UNKNOWN;
    }
}
