package ru.yandex.calendar.frontend.display;

import org.joda.time.LocalDateTime;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.bolts.collection.Option;
import ru.yandex.calendar.CalendarRequest;
import ru.yandex.calendar.frontend.display.dto.MeetingData;
import ru.yandex.calendar.frontend.display.dto.MeetingIdInfo;
import ru.yandex.calendar.frontend.display.dto.RoomsInfo;
import ru.yandex.calendar.frontend.display.dto.StateInfo;
import ru.yandex.calendar.frontend.display.dto.TokenInfo;
import ru.yandex.calendar.frontend.webNew.dto.out.StatusResult;
import ru.yandex.calendar.logic.event.ActionInfo;
import ru.yandex.calendar.logic.user.Language;
import ru.yandex.commune.a3.action.Action;
import ru.yandex.commune.a3.action.ActionContainer;
import ru.yandex.commune.a3.action.parameter.bind.annotation.RequestParam;
import ru.yandex.misc.db.masterSlave.MasterSlavePolicy;
import ru.yandex.misc.db.masterSlave.WithMasterSlavePolicy;

@ActionContainer
public class DisplayActions {
    @Autowired
    private DisplayManager displayManager;

    private static ActionInfo getActionInfo() {
        return CalendarRequest.getCurrent().getActionInfo();
    }

    @WithMasterSlavePolicy(MasterSlavePolicy.R_MS)
    @Action
    public RoomsInfo findUnassignedRooms(@RequestParam("lang") Option<Language> lang) {
        return displayManager.findUnassignedRooms(lang.getOrElse(Language.RUSSIAN), getActionInfo());
    }

    @WithMasterSlavePolicy(MasterSlavePolicy.RW_M)
    @Action
    public TokenInfo assignRoom(@RequestParam("id") long id) {
        return displayManager.assignRoom(id);
    }

    @WithMasterSlavePolicy(MasterSlavePolicy.R_MS)
    @Action
    public StateInfo state(@RequestParam("token") String token,
                           @RequestParam("lang") Option<Language> lang) {
        return displayManager.getState(token, lang.getOrElse(Language.RUSSIAN), getActionInfo());
    }

    @WithMasterSlavePolicy(MasterSlavePolicy.RW_M)
    @Action
    public MeetingIdInfo createMeeting(@RequestParam("token") String token,
                                       @RequestParam("name") String name,
                                       @RequestParam("start") LocalDateTime start,
                                       @RequestParam("end") LocalDateTime end) {
        return displayManager.createMeeting(token, new MeetingData(start, end, name), getActionInfo());
    }

    @WithMasterSlavePolicy(MasterSlavePolicy.RW_M)
    @Action
    public StatusResult moveMeetingEnd(@RequestParam("token") String token,
                                       @RequestParam("id") long eventId,
                                       @RequestParam("instanceStart") LocalDateTime instanceStart,
                                       @RequestParam("end") LocalDateTime end) {
        displayManager.moveMeetingEnd(token, eventId, instanceStart, end, getActionInfo());
        return StatusResult.ok();
    }

    @WithMasterSlavePolicy(MasterSlavePolicy.RW_M)
    @Action
    public StatusResult declineMeeting(@RequestParam("token") String token,
                                       @RequestParam("id") long eventId,
                                       @RequestParam("instanceStart") LocalDateTime instanceStart) {
        displayManager.declineMeeting(token, eventId, instanceStart, getActionInfo());
        return StatusResult.ok();
    }

    @WithMasterSlavePolicy(MasterSlavePolicy.RW_M)
    @Action
    public StatusResult deleteMeeting(@RequestParam("token") String token,
                                      @RequestParam("id") long eventId,
                                      @RequestParam("instanceStart") LocalDateTime instanceStart) {
        displayManager.deleteMeeting(token, eventId, instanceStart, getActionInfo());
        return StatusResult.ok();
    }
}
