package ru.yandex.calendar.frontend.display;

import javax.annotation.PostConstruct;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.calendar.boot.CalendarAppName;
import ru.yandex.calendar.frontend.a3.bind.JsonBinder;
import ru.yandex.calendar.frontend.a3.converters.CalendarConverterToLocalDateTime;
import ru.yandex.calendar.frontend.a3.converters.ConverterToLanguage;
import ru.yandex.calendar.frontend.a3.interceptors.CalendarRequestInterceptor;
import ru.yandex.calendar.frontend.a3.interceptors.CommandExecutionMonitoringInterceptor;
import ru.yandex.calendar.frontend.a3.interceptors.LogActionParametersInterceptor;
import ru.yandex.calendar.frontend.a3.interceptors.SetAdditionalAttrsInterceptor;
import ru.yandex.calendar.logic.domain.PassportAuthDomainsHolder;
import ru.yandex.calendar.logic.event.ActionSource;
import ru.yandex.calendar.monitoring.WebApiMonitoringConfiguration;
import ru.yandex.calendar.tvm.TvmManager;
import ru.yandex.commune.a3.ActionApp;
import ru.yandex.commune.a3.action.A3DefaultContextConfiguration;
import ru.yandex.commune.a3.action.result.ApplicationInfo;
import ru.yandex.commune.a3.action.result.ApplicationResultType;
import ru.yandex.commune.a3.action.result.pojo.JsonPojoResultSerializer;
import ru.yandex.commune.a3.action.result.type.MediaType;
import ru.yandex.misc.version.Version;
import ru.yandex.misc.web.servletContainer.SingleWarJetty;

/**
 * @author dbrylev
 */
@Configuration
@Import({
        A3DefaultContextConfiguration.class,
        WebApiMonitoringConfiguration.class,
})
public class DisplayContextA3Configuration {

    @Autowired
    @Qualifier("webNewJetty")
    private SingleWarJetty jetty;
    @Autowired
    private ActionApp actionApp;

    @PostConstruct
    public void configure() {
        jetty.addServletMapping("/display/*", actionApp.createServlet());
    }

    @Bean
    public ApplicationInfo applicationInfo(CalendarAppName calendarAppName, Version version) {
        return new ApplicationInfo(calendarAppName.appName(), version.getProjectVersion());
    }

    @Bean
    public DisplayActions displayActions() {
        return new DisplayActions();
    }

    @Bean
    public ApplicationResultType applicationResultType() {
        return new ApplicationResultType(MediaType.APPLICATION_JSON);
    }

    @Bean
    public CalendarRequestInterceptor calendarRequestInterceptor(PassportAuthDomainsHolder domains, TvmManager tvmManager) {
        return new CalendarRequestInterceptor(ActionSource.DISPLAY, domains, tvmManager);
    }

    @Bean
    public LogActionParametersInterceptor logActionParametersInterceptor() {
        return new LogActionParametersInterceptor();
    }

    @Bean
    public SetAdditionalAttrsInterceptor setAdditionalAttrsInterceptor() {
        return new SetAdditionalAttrsInterceptor();
    }

    @Bean
    public JsonBinder jsonBinder() {
        return new JsonBinder(DisplayBender.mapper);
    }

    @Bean
    public JsonPojoResultSerializer jsonPojoResultSerializer() {
        return new JsonPojoResultSerializer(DisplayBender.mapper);
    }

    @Bean
    public CalendarConverterToLocalDateTime converterToLocalDateTime() {
        return new CalendarConverterToLocalDateTime();
    }

    @Bean
    public ConverterToLanguage converterToLanguage() {
        return new ConverterToLanguage();
    }

    @Bean
    public CommandExecutionMonitoringInterceptor commandExecutionMonitoringInterceptor() {
        return new CommandExecutionMonitoringInterceptor();
    }
}
