package ru.yandex.calendar.frontend.display.dto;

import java.util.List;

import lombok.Value;
import lombok.val;
import org.joda.time.DateTimeZone;
import org.joda.time.LocalDateTime;

import ru.yandex.bolts.collection.CollectorsF;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.calendar.frontend.bender.WebDateTime;
import ru.yandex.calendar.frontend.webNew.dto.in.WebEventData;
import ru.yandex.calendar.frontend.webNew.dto.in.WebEventUserData;
import ru.yandex.calendar.logic.beans.generated.Event;
import ru.yandex.calendar.logic.event.avail.Availability;
import ru.yandex.calendar.logic.event.model.EventData;
import ru.yandex.calendar.logic.event.model.EventInvitationData;
import ru.yandex.calendar.logic.event.model.EventInvitationsData;
import ru.yandex.calendar.logic.event.model.EventType;
import ru.yandex.calendar.logic.sharing.perm.EventActionClass;
import ru.yandex.misc.email.Email;

import static ru.yandex.calendar.frontend.display.DisplayManager.ROBOT_RES_MASTER_EMAIL;

@Value
public class MeetingData {
    LocalDateTime start;
    LocalDateTime end;
    String name;

    public WebEventData toWebEventData(DateTimeZone tz, ListF<Email> attendees, ListF<Email> optionalAttendees) {
        val userData = new WebEventUserData(Option.of(Availability.AVAILABLE), Option.empty(), Option.empty());

        val eventData = WebEventData.empty();
        eventData.setType(Option.of(EventType.USER));
        eventData.setIsAllDay(Option.of(false));
        eventData.setStartTs(Option.of(WebDateTime.dateTime(start.toDateTime(tz))));
        eventData.setEndTs(Option.of(WebDateTime.dateTime(end.toDateTime(tz))));
        eventData.setName(Option.of(name));
        eventData.setParticipantsCanInvite(Option.of(false));
        eventData.setParticipantsCanEdit(Option.of(false));
        eventData.setOthersCanView(Option.of(true));
        eventData.setOrganizer(Option.of(ROBOT_RES_MASTER_EMAIL));
        eventData.setAttendeeEmails(Option.of(attendees));
        eventData.setOptionalAttendeeEmails(Option.of(optionalAttendees));
        eventData.setUserData(userData);
        return eventData;
    }

    public EventData toEventData(DateTimeZone tz, Email organizer, List<Email> attendees) {
        val event = new Event();
        event.setStartTs(start.toDateTime(tz).toInstant());
        event.setEndTs(end.toDateTime(tz).toInstant());
        event.setIsAllDay(false);
        event.setParticipantsInvite(false);
        event.setPermParticipants(EventActionClass.VIEW);
        event.setPermAll(EventActionClass.VIEW);
        event.setType(EventType.USER);
        event.setName(name);

        val eventData = new EventData();
        eventData.setTimeZone(tz);
        val invitations = attendees.stream()
            .map(EventInvitationData::new)
            .collect(CollectorsF.toList());
        eventData.setInvData(new EventInvitationsData(Option.of(organizer), invitations));
        eventData.setEvent(event);
        return eventData;
    }
}
