package ru.yandex.calendar.frontend.display.dto;

import lombok.Data;
import org.joda.time.LocalDateTime;

import ru.yandex.bolts.collection.Option;
import ru.yandex.commune.a3.action.result.pojo.ActionResultPojo;
import ru.yandex.misc.bender.MembersToBind;
import ru.yandex.misc.bender.annotation.BenderMembersToBind;

/**
 * @author dbrylev
 */
@Data
@ActionResultPojo
@BenderMembersToBind(MembersToBind.ALL_FIELDS)
public class MeetingIdInfo {
    private final Option<Long> id;
    private final Option<LocalDateTime> instanceStart;
    private final Option<Boolean> temporaryReservation;
    private final Option<Boolean> bookingRestriction;

    public static MeetingIdInfo event(long id, LocalDateTime instanceStart) {
        return new MeetingIdInfo(Option.of(id), Option.of(instanceStart), Option.empty(), Option.empty());
    }

    public static MeetingIdInfo temporaryReservation() {
        return new MeetingIdInfo(Option.empty(), Option.empty(), Option.of(true), Option.empty());
    }

    public static MeetingIdInfo bookingRestriction() {
        return new MeetingIdInfo(Option.empty(), Option.empty(), Option.empty(), Option.of(true));
    }
}
