package ru.yandex.calendar.frontend.display.dto;

import lombok.AllArgsConstructor;
import lombok.Getter;
import org.joda.time.DateTimeZone;
import org.joda.time.LocalDateTime;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.misc.bender.MembersToBind;
import ru.yandex.misc.bender.annotation.Bendable;
import ru.yandex.misc.bender.annotation.BenderFlatten;
import ru.yandex.misc.bender.annotation.BenderMembersToBind;
import ru.yandex.misc.time.InstantInterval;

@Bendable
@AllArgsConstructor
@BenderMembersToBind(MembersToBind.ALL_FIELDS)
public class MeetingInfo {
    @BenderFlatten
    private final MeetingIdInfo id;

    private final String name;
    @Getter private final LocalDateTime start;
    @Getter private final LocalDateTime end;

    private final Option<MeetingParticipantInfo> organizer;
    private final ListF<MeetingParticipantInfo> attendees;

    public InstantInterval getInterval(DateTimeZone tz) {
        return new InstantInterval(getStart().toDateTime(tz), getEnd().toDateTime(tz));
    }
}
