package ru.yandex.calendar.frontend.display.dto;

import org.joda.time.LocalDateTime;

import ru.yandex.misc.bender.MembersToBind;
import ru.yandex.misc.bender.annotation.Bendable;
import ru.yandex.misc.bender.annotation.BenderMembersToBind;

/**
 * @author dbrylev
 */
@Bendable
@BenderMembersToBind(MembersToBind.ALL_FIELDS)
public class RoomInfo {
    private final long id;
    private final String name;
    private final String alterName;
    private final String officeName;

    private final LocalDateTime currentTime;
    private final boolean isActive;

    public RoomInfo(
            long id, String name, String alterName, String officeName,
            LocalDateTime currentTime, boolean active)
    {
        this.id = id;
        this.name = name;
        this.alterName = alterName;
        this.officeName = officeName;
        this.currentTime = currentTime;
        this.isActive = active;
    }
}
