package ru.yandex.calendar.frontend.display.dto;

import lombok.AllArgsConstructor;
import org.joda.time.DateTimeZone;
import org.joda.time.LocalDateTime;

import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.function.Function;
import ru.yandex.misc.bender.MembersToBind;
import ru.yandex.misc.bender.annotation.Bendable;
import ru.yandex.misc.bender.annotation.BenderMembersToBind;
import ru.yandex.misc.time.InstantInterval;

@Bendable
@AllArgsConstructor
@BenderMembersToBind(MembersToBind.ALL_FIELDS)
public class ScheduleIntervalInfo {
    private final LocalDateTime start;
    private final LocalDateTime end;
    private final Option<MeetingInfo> meeting;

    public static Function<MeetingInfo, ScheduleIntervalInfo> meetingF() {
        return m -> new ScheduleIntervalInfo(m.getStart(), m.getEnd(), Option.of(m));
    }

    public static Function<InstantInterval, ScheduleIntervalInfo> gapF(final DateTimeZone tz) {
        return i -> new ScheduleIntervalInfo(
                new LocalDateTime(i.getStart(), tz),
                new LocalDateTime(i.getEnd(), tz),
                Option.empty());
    }

    public static Function<ScheduleIntervalInfo, LocalDateTime> getStartF() {
        return i -> i.start;
    }
}
