package ru.yandex.calendar.frontend.ews;

import ru.yandex.bolts.function.Function0;
import ru.yandex.calendar.logic.resource.UidOrResourceId;


@SuppressWarnings("serial")
public class EwsSubjectNotSubscribedException extends EwsException {
    public EwsSubjectNotSubscribedException() {
    }

    public EwsSubjectNotSubscribedException(String message) {
        super(message);
    }

    public EwsSubjectNotSubscribedException(Throwable cause) {
        super(cause);
    }

    public EwsSubjectNotSubscribedException(String message, Throwable cause) {
        super(message, cause);
    }


    public static Function0<EwsSubjectNotSubscribedException> consF(final UidOrResourceId subjectId) {
        return () -> new EwsSubjectNotSubscribedException("Subject is not subscribed: " + subjectId);
    }
}
