package ru.yandex.calendar.frontend.ews;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.calendar.frontend.ews.compare.EwsComparator;
import ru.yandex.calendar.frontend.ews.exp.EventToCalendarItemConverter;
import ru.yandex.calendar.frontend.ews.exp.EwsExportRoutines;
import ru.yandex.calendar.frontend.ews.exp.async.EwsResourceMeetingExporter;
import ru.yandex.calendar.frontend.ews.hook.EwsNotificationEventHandler;
import ru.yandex.calendar.frontend.ews.hook.EwsNtfContextConfiguration;
import ru.yandex.calendar.frontend.ews.imp.EwsImporter;
import ru.yandex.calendar.frontend.ews.proxy.EwsProxyWrapperContextConfiguration;
import ru.yandex.calendar.frontend.ews.replace.EwsResourceMeetingReplacer;
import ru.yandex.calendar.frontend.ews.subscriber.ExchangeSubscriber;
import ru.yandex.calendar.frontend.ews.sync.EwsEventsPuller;
import ru.yandex.calendar.frontend.ews.sync.EwsEventsSynchronizer;
import ru.yandex.calendar.frontend.ews.sync.IgnoredEventManager;

/**
 * Beans that can be safely added to any context.
 *
 * @author Stepan Koltsov
 * @see EwsNtfContextConfiguration
 */
@Configuration
@Import({ EwsProxyWrapperContextConfiguration.class })
public class ExchangeClientContextConfiguration {

    @Bean
    public EwsComparator ewsComparator() {
        return new EwsComparator();
    }

    @Bean
    public EwsExportRoutines ewsExportRoutines() {
        return new EwsExportRoutines();
    }

    @Bean
    public EwsResourceMeetingExporter ewsResourceMeetingExporter() {
        return new EwsResourceMeetingExporter();
    }

    @Bean
    public IgnoredEventManager ignoredEventManager() {
        return new IgnoredEventManager();
    }

    @Bean
    public ExchangeSubscriber exchangeSubscriber() {
        return new ExchangeSubscriber();
    }

    @Bean
    public EwsImporter ewsImporter() {
        return new EwsImporter();
    }

    @Bean
    public EwsEventsSynchronizer ewsEventsSynchronizer() {
        return new EwsEventsSynchronizer();
    }

    @Bean
    public EwsEventsPuller ewsEventsPuller() {
        return new EwsEventsPuller();
    }

    @Bean
    public EwsNotificationEventHandler ewsNotificationEventHandler() {
        return new EwsNotificationEventHandler();
    }

    @Bean
    public ExchangeEmailManager exchangeEmailManager() {
        return new ExchangeEmailManager();
    }

    @Bean
    public EventToCalendarItemConverter eventToCalendarItemConverter() {
        return new EventToCalendarItemConverter();
    }

    @Bean
    public EwsResourceMeetingReplacer ewsResourceMeetingReplacer() {
        return new EwsResourceMeetingReplacer();
    }

} //~
