package ru.yandex.calendar.frontend.ews;

import org.joda.time.Instant;

import ru.yandex.bolts.collection.Either;
import ru.yandex.bolts.function.Function;

/**
 * @author Stepan Koltsov
 */
public class ExchangeRepetitionEnd {

    private final Either<Integer, Instant> end;

    private ExchangeRepetitionEnd(Either<Integer, Instant> end) {
        this.end = end;
    }

    public static ExchangeRepetitionEnd count(int count) {
        return new ExchangeRepetitionEnd(Either.<Integer, Instant>left(count));
    }

    public static ExchangeRepetitionEnd instant(Instant instant) {
        return new ExchangeRepetitionEnd(Either.<Integer, Instant>right(instant));
    }

    public boolean isCount() {
        return end.isLeft();
    }

    public boolean isInstant() {
        return end.isRight();
    }

    public int getCount() {
        return end.getLeft();
    }

    public Instant getInstant() {
        return end.getRight();
    }

    public <T> T fold(Function<Integer, T> left, Function<Instant, T> right) {
        return end.fold(left, right);
    }

} //~
