package ru.yandex.calendar.frontend.ews;

import org.joda.time.Instant;

import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.function.Function1B;
import ru.yandex.misc.email.Email;

/**
 * @author akirakozov
 */
public class ExtendedCalendarItemProperties {
    private final Option<Email> organizer;
    private final boolean wasCreatedFromYaTeamCalendar;
    private final Option<Instant> recurrenceId;

    public ExtendedCalendarItemProperties(
            Option<Email> organizer, boolean wasCreatedFromYaTeamCalendar, Option<Instant> recurrenceId)
    {
        this.organizer = organizer;
        this.wasCreatedFromYaTeamCalendar = wasCreatedFromYaTeamCalendar;
        this.recurrenceId = recurrenceId;
    }

    public boolean getWasCreatedFromYaTeamCalendar() {
        return wasCreatedFromYaTeamCalendar;
    }

    public Option<Email> getOrganizerEmail() {
        return organizer;
    }

    public Option<Instant> getRecurrenceId() {
        return recurrenceId;
    }

    public static Function1B<ExtendedCalendarItemProperties> wasCreatedFromYaTeamCalendarF() {
        return new Function1B<ExtendedCalendarItemProperties>() {
            public boolean apply(ExtendedCalendarItemProperties p) {
                return p.getWasCreatedFromYaTeamCalendar();
            }
        };
    }
}
