package ru.yandex.calendar.frontend.ews.compare;

import lombok.AllArgsConstructor;
import lombok.Getter;

import ru.yandex.bolts.collection.SetF;
import ru.yandex.bolts.function.Function;
import ru.yandex.bolts.function.Function1B;
import ru.yandex.calendar.frontend.ews.compare.EwsComparator.EventKey;
import ru.yandex.calendar.logic.resource.UidOrResourceId;
import ru.yandex.misc.email.Email;
import ru.yandex.misc.lang.StringUtils;
import ru.yandex.misc.time.InstantInterval;

/**
 * XXX remove needless fields, now they are needed for debug
 * @author ssytnik
 */
@AllArgsConstructor
@Getter
public class EwsCompareResult {
    private Email exchangeEmail;
    private UidOrResourceId subjectId;
    private InstantInterval interval;
    private SetF<EventKey> commonKeys;
    private SetF<EventKey> exchangeUniqueKeys;
    private SetF<EventKey> calendarUniqueKeys;

    public boolean hasDiffs() {
        return exchangeUniqueKeys.isNotEmpty() || calendarUniqueKeys.isNotEmpty();
    }

    @Override
    public String toString() {
        return
                exchangeEmail + ": " + subjectId + " [\n" +
                "  " + interval + "\n" +
                outKeys(commonKeys, "common") +
                outKeys(exchangeUniqueKeys, "exchange") +
                outKeys(calendarUniqueKeys, "calendar") +
                "]";
    }

    private static String outKeys(SetF<EventKey> keys, String keyName) {
        return
                "  " + StringUtils.rightPad(keyName, 9) +
                "(" + StringUtils.leftPad(String.valueOf(keys.size()), 2) + "): " +
                keys.sortedBy(EventKey.getStartTsF()) + "\n";
    }

    public static Function1B<EwsCompareResult> hasDiffsF() {
        return new Function1B<EwsCompareResult>() {
            public boolean apply(EwsCompareResult a) {
                return a.hasDiffs();
            }
        };
    }

    public static Function<EwsCompareResult, Integer> getCommonKeysSizeF() {
        return new Function<EwsCompareResult, Integer>() {
            public Integer apply(EwsCompareResult a) {
                return a.commonKeys.size();
            }
        };
    }

    public static Function<EwsCompareResult, Integer> getExchangeUniqueKeysSizeF() {
        return new Function<EwsCompareResult, Integer>() {
            public Integer apply(EwsCompareResult a) {
                return a.exchangeUniqueKeys.size();
            }
        };
    }

    public static Function<EwsCompareResult, Integer> getCalendarUniqueKeysSizeF() {
        return new Function<EwsCompareResult, Integer>() {
            public Integer apply(EwsCompareResult a) {
                return a.calendarUniqueKeys.size();
            }
        };
    }

    public EwsCompareResultBrief toBrief(
            Function<EwsCompareResult, Integer> diffsWithKnownReasonF,
            Function<EwsCompareResult, Integer> calendarUniqueWithEwsSyncF,
            Function<EwsCompareResult, Integer> commonWithEwsSyncF)
    {
        return new EwsCompareResultBrief(commonKeys.size(), exchangeUniqueKeys.size(),
                calendarUniqueKeys.size(),
                diffsWithKnownReasonF.apply(this),
                calendarUniqueWithEwsSyncF.apply(this), commonWithEwsSyncF.apply(this));
    }
}
