package ru.yandex.calendar.frontend.ews.compare;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.misc.lang.DefaultObject;

/**
 * @author yashunsky
 */
public class EwsCompareResultBrief extends DefaultObject {
    private final int common;
    private final int exchange;
    private final int calendar;
    private final int diffsWithKnownReason;
    private final int calendarUniqueWithEwsSync;
    private final int commonWithEwsSync;

    public EwsCompareResultBrief(int common, int exchange, int calendar, int diffsWithKnownReason,
            int calendarUniqueWithEwsSync, int commonWithEwsSync)
    {
        this.common = common;
        this.exchange = exchange;
        this.calendar = calendar;
        this.diffsWithKnownReason = diffsWithKnownReason;
        this.calendarUniqueWithEwsSync = calendarUniqueWithEwsSync;
        this.commonWithEwsSync = commonWithEwsSync;
    }

    public static EwsCompareResultBrief plus(EwsCompareResultBrief operandA, EwsCompareResultBrief operandB) {
        return new EwsCompareResultBrief(
                operandA.common + operandB.common,
                operandA.exchange + operandB.exchange,
                operandA.calendar + operandB.calendar,
                operandA.diffsWithKnownReason + operandB.diffsWithKnownReason,
                operandA.calendarUniqueWithEwsSync + operandB.calendarUniqueWithEwsSync,
                operandA.commonWithEwsSync + operandB.commonWithEwsSync);
    }

    public int getCommon() {
        return common;
    }

    public int getExchange() {
        return exchange;
    }

    public int getCalendar() {
        return calendar;
    }

    public int getDiffsWithKnownReason() {
        return diffsWithKnownReason;
    }

    public int getCalendarUniqueWithEwsSync() {
        return calendarUniqueWithEwsSync;
    }

    public int getCommonWithEwsSync() {
        return commonWithEwsSync;
    }

    public MapF<String, Integer> asMap() {
        return Cf.list("common", "exchange", "calendar", "diffsWithKnownReason",
                "calendarUniqueWithEwsSync", "commonWithEwsSync")
                .zip(Cf.list(common, exchange, calendar, diffsWithKnownReason,
                        calendarUniqueWithEwsSync, commonWithEwsSync)).toMap();
    }
}
