package ru.yandex.calendar.frontend.ews.exp;

import com.microsoft.schemas.exchange.services._2006.types.CalendarItemTypeType;
import org.joda.time.Instant;

import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.function.Function;
import ru.yandex.bolts.function.Function1B;
import ru.yandex.calendar.frontend.ews.proxy.ExchangeIdLogData;
import ru.yandex.calendar.logic.log.EventIdLogDataJson;
import ru.yandex.calendar.logic.resource.UidOrResourceId;
import ru.yandex.misc.time.InstantInterval;

public class ConflictingItem {
    private final String exchangeId;
    private final String name;
    private final Instant start;
    private final Instant end;
    private final Option<Instant> recurrenceId;
    private final String externalId;
    private final CalendarItemTypeType type;
    private final boolean isFromCalendar;

    public ConflictingItem(
            String exchangeId, String name, Instant start, Instant end,
            Option<Instant> recurrenceId, String externalId, CalendarItemTypeType type, boolean isFromCalendar)
    {
        this.exchangeId = exchangeId;
        this.name = name;
        this.start = start;
        this.end = end;
        this.recurrenceId = recurrenceId;
        this.externalId = externalId;
        this.type = type;
        this.isFromCalendar = isFromCalendar;
    }

    public String getExchangeId() {
        return exchangeId;
    }

    public String getName() {
        return name;
    }

    public Instant getStart() {
        return start;
    }

    public Instant getEnd() {
        return end;
    }

    public InstantInterval getInterval() {
        return new InstantInterval(getStart(), getEnd());
    }

    public Option<Instant> getRecurrenceId() {
        return recurrenceId;
    }

    public String getExternalId() {
        return externalId;
    }

    public CalendarItemTypeType getType() {
        return type;
    }

    public boolean isFromCalendar() {
        return isFromCalendar;
    }

    public ExchangeIdLogData getExchangeIdLogData(long resourceId) {
        return new ExchangeIdLogData(
                exchangeId, UidOrResourceId.resource(resourceId), new EventIdLogDataJson(0L, 0L, externalId, recurrenceId.toOptional()));
    }

    public static Function<ConflictingItem, String> getExchangeIdF() {
        return c -> c.getExchangeId();
    }

    public static Function<ConflictingItem, String> getNameF() {
        return c -> c.getName();
    }

    public static Function<ConflictingItem, Instant> getStartF() {
        return c -> c.getStart();
    }
    public static Function<ConflictingItem, Instant> getEndF() {
        return c -> c.getEnd();
    }

    public static Function<ConflictingItem, Option<Instant>> getRecurrenceIdF() {
        return c -> c.getRecurrenceId();
    }

    public static Function<ConflictingItem, String> getExternalIdF() {
        return c -> c.getExternalId();
    }

    public static Function1B<ConflictingItem> isFromCalendarF() {
        return c -> c.isFromCalendar();
    }

    public static Function<ConflictingItem, CalendarItemTypeType> getTypeF() {
        return c -> c.getType();
    }
}
