package ru.yandex.calendar.frontend.ews.exp;

import org.joda.time.Instant;

import ru.yandex.bolts.collection.Either;
import ru.yandex.bolts.collection.Tuple2;
import ru.yandex.misc.email.Email;
import ru.yandex.misc.lang.DefaultObject;
import ru.yandex.misc.time.InstantInterval;

/**
 * @author akirakozov
 */
public class EwsModifyingItemId extends DefaultObject {
    private final Either<String, Tuple2<Email, OccurrenceId>> value;

    private EwsModifyingItemId(Either<String, Tuple2<Email, OccurrenceId>> value) {
        this.value = value;
    }

    public boolean isOccurrence() {
        return value.isRight();
    }

    public static EwsModifyingItemId fromExchangeId(String exchangeId) {
        return new EwsModifyingItemId(Either.left(exchangeId));
    }

    public static EwsModifyingItemId fromEmailAndOccurrenceId(
            Email email, OccurrenceId occurrenceId)
    {
        return new EwsModifyingItemId(Either.right(Tuple2.tuple(email, occurrenceId)));
    }

    public String getExchangeId() {
        return value.getLeft();
    }

    public Email getEmail() {
        return value.getRight().get1();
    }

    public String getExternalId() {
        return value.getRight().get2().getExternalId();
    }

    public InstantInterval getInstanceInterval() {
        return value.getRight().get2().getInstanceInterval();
    }

    public Instant getOccurrenceId() {
        return value.getRight().get2().getOccurrenceId();
    }
}
