package ru.yandex.calendar.frontend.ews.exp;

import lombok.Value;
import org.joda.time.DateTimeZone;
import org.joda.time.Instant;

import ru.yandex.calendar.logic.beans.generated.Event;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;
import ru.yandex.misc.time.InstantInterval;

@BenderBindAllFields
@Value
public class OccurrenceId {
    String externalId;
    InstantInterval instanceInterval;
    Instant occurrenceId;

    public static OccurrenceId fromEvent(String externalId, Event event) {
        return new OccurrenceId(externalId,
                new InstantInterval(event.getStartTs(), event.getEndTs()),
                event.getRecurrenceId().getOrThrow("Recurrence event expected"));
    }

    public OccurrenceId plusDays(int days, DateTimeZone tz) {
        return new OccurrenceId(externalId,
                new InstantInterval(
                        instanceInterval.getStart().toDateTime(tz).plusDays(days),
                        instanceInterval.getEnd().toDateTime(tz).plusDays(days)),
                occurrenceId.toDateTime(tz).plusDays(days).toInstant());
    }
}
