package ru.yandex.calendar.frontend.ews.exp;

import java.util.Optional;

import lombok.AllArgsConstructor;
import lombok.Value;

import ru.yandex.calendar.logic.resource.ResourceInfo;
import ru.yandex.calendar.logic.resource.ResourceRoutines;
import ru.yandex.calendar.logic.resource.UidOrResourceId;
import ru.yandex.calendar.logic.sharing.participant.ResourceParticipantInfo;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;
import ru.yandex.misc.email.Email;

@Value
@AllArgsConstructor
@BenderBindAllFields
public class ResourceParticipantBriefInfo {
    String exchangeEmail;
    String resourceEmail;
    long resourceId;
    long eventId;
    boolean asyncWithExchange;
    Optional<String> exchangeId;
    boolean yandexTeam;
    boolean syncWithExchange;

    ResourceParticipantBriefInfo(ResourceParticipantInfo resource, Email exchangeEmail) {
        this(exchangeEmail.getEmail(),
                ResourceRoutines.getResourceEmail(resource.getResource()).getEmail(),
                resource.getResourceId(),
                resource.getEventId(),
                resource.getResource().getAsyncWithExchange(),
                resource.getExchangeId().toOptional(),
                ResourceInfo.isYaTeamF().apply(resource.getResourceInfo()),
                ResourceInfo.isSyncWithExchangeF().apply(resource.getResourceInfo()));
    }

    public Email getExchangeEmail() {
        return new Email(exchangeEmail);
    }

    public Email getResourceEmail() {
        return new Email(resourceEmail);
    }

    public UidOrResourceId getUidOrResourceId() {
        return UidOrResourceId.resource(resourceId);
    }
}
