package ru.yandex.calendar.frontend.ews.exp.async;

import org.joda.time.Instant;

import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.function.Function;
import ru.yandex.calendar.logic.beans.generated.Resource;
import ru.yandex.calendar.logic.event.EventInfo;
import ru.yandex.calendar.logic.sharing.participant.ResourceParticipantInfo;
import ru.yandex.misc.email.Email;

/**
 * @author dbrylev
 */
class CreatedMeeting {
    private final ResourceParticipantInfo resourceParticipant;
    private final Email exchangeEmail;
    private final String exchangeId;
    private final EventInfo event;

    CreatedMeeting(
            ResourceParticipantInfo resourceParticipant, Email exchangeEmail,
            String exchangeId, EventInfo event)
    {
        this.resourceParticipant = resourceParticipant;
        this.exchangeEmail = exchangeEmail;
        this.exchangeId = exchangeId;
        this.event = event;
    }

    public ResourceParticipantInfo getResourceParticipant() {
        return resourceParticipant;
    }

    public Email getExchangeEmail() {
        return exchangeEmail;
    }

    public String getExternalId() {
        return event.getMainEvent().getExternalId();
    }

    public Resource getResource() {
        return resourceParticipant.getResource();
    }

    public long getEventId() {
        return resourceParticipant.getEventId();
    }

    public String getExchangeId() {
        return exchangeId;
    }

    public EventInfo getEvent() {
        return event;
    }

    public long getResourceId() {
        return getResource().getId();
    }

    public Option<Instant> getRecurrenceId() {
        return event.getRecurrenceId();
    }

    public static Function<CreatedMeeting, String> getExchangeIdF() {
        return new Function<CreatedMeeting, String>() {
            public String apply(CreatedMeeting m) {
                return m.getExchangeId();
            }
        };
    }
}
