package ru.yandex.calendar.frontend.ews.exp.async;

import org.joda.time.Instant;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.function.Function1V;
import ru.yandex.calendar.logic.beans.GenericBeanDao;
import ru.yandex.calendar.logic.beans.generated.YtEwsExportingEvent;
import ru.yandex.calendar.logic.beans.generated.YtEwsExportingEventFields;
import ru.yandex.calendar.logic.beans.generated.YtEwsExportingEventHelper;
import ru.yandex.calendar.util.db.CalendarJdbcDaoSupport;

/**
 * @author dbrylev
 */
public class YtEwsExportingEventDao extends CalendarJdbcDaoSupport {

    @Autowired
    public GenericBeanDao genericBeanDao;

    public void replaceEvents(ListF<YtEwsExportingEvent> events) {
        genericBeanDao.upsertBeans(events);
    }

    public void updateByExternalIdAndLastSubmitTs(YtEwsExportingEvent data, String externalId, Instant submitTs) {
        genericBeanDao.updateBeans(data, YtEwsExportingEventFields.EXTERNAL_ID.eq(externalId)
                .and(YtEwsExportingEventFields.LAST_SUBMIT_TS.eq(submitTs)));
    }

    public void findEventsScheduledBefore(
            Function1V<ListF<YtEwsExportingEvent>> callback, Instant before, int rowsPerCallback)
    {
        genericBeanDao.loadBeans(
                YtEwsExportingEventHelper.INSTANCE,
                YtEwsExportingEventFields.NEXT_ATTEMPT_TS.lt(before),
                YtEwsExportingEventFields.NEXT_ATTEMPT_TS,
                rowsPerCallback, callback.asFunctionReturnValue(Cf.list()));
    }

    public void deleteEventByExternalIdSubmittedNotAfter(String externalId, Instant maxSubmitTs) {
        genericBeanDao.deleteBeans(
                YtEwsExportingEventHelper.INSTANCE,
                YtEwsExportingEventFields.EXTERNAL_ID.eq(externalId)
                        .and(YtEwsExportingEventFields.LAST_SUBMIT_TS.le(maxSubmitTs)));
    }
}
