package ru.yandex.calendar.frontend.ews.hook;

import ru.yandex.bolts.function.Function1B;

/**
 * @author akirakozov
 */
public enum EwsNotificationEventType {
    CREATE("CreatedEvent", 0),
    MODIFIED("ModifiedEvent", 1),
    MOVED("MovedEvent", 2),
    DELETE("DeletedEvent", 3),
    ;

    // event notification event name
    private final String name;
    private final int processPriority;

    private EwsNotificationEventType(String name, int processPriority) {
        this.name = name;
        this.processPriority = processPriority;
    }

    public String getName() {
        return name;
    }

    public int getProcessPriority() {
        return processPriority;
    }

    public Function1B<String> nameEq = new Function1B<String>() {
        public boolean apply(String name) {
            return EwsNotificationEventType.this.getName().equals(name);
        }
    };
}
