package ru.yandex.calendar.frontend.ews.hook;

import lombok.val;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.calendar.admin.CalendarPingServlet;
import ru.yandex.calendar.frontend.ews.ExchangeClientContextConfiguration;
import ru.yandex.calendar.util.JettyConfiguration;
import ru.yandex.misc.web.servletContainer.SingleWarJetty;

/**
 * @see ExchangeClientContextConfiguration
 */
@Configuration
public class EwsNtfContextConfiguration {
    @Bean
    public SingleWarJetty ntfEwsJetty() {
        val jetty = JettyConfiguration.fromProperties("ews").consJetty();

        jetty.addServletMapping("/ping/*", pingConfigurableServletEws());
        jetty.addServletMapping("/soap/*", notificationEwsServlet2());

        return jetty;
    }


    @Bean
    public CalendarPingServlet pingConfigurableServletEws() {
        return new CalendarPingServlet();
    }

    @Bean
    public NotificationEwsServlet2 notificationEwsServlet2() {
        return new NotificationEwsServlet2();
    }

    @Bean
    public NotificationExchangeWebService notificationExchangeWebService() {
        return new NotificationExchangeWebService();
    }

    @Bean
    public EwsNotificationEventHandler ewsNotificationEventHandler() {
        return new EwsNotificationEventHandler();
    }
}
