package ru.yandex.calendar.frontend.ews.hook;

import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilderFactory;

import com.microsoft.schemas.exchange.services._2006.messages.SendNotificationResponseType;
import com.microsoft.schemas.exchange.services._2006.messages.SendNotificationResultType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

import ru.yandex.misc.ExceptionUtils;

/**
 * @author gutman
 */
public class EwsXmlizer {

    private final static JAXBContext jaxbContext;
    static {
        try {
            jaxbContext = JAXBContext.newInstance(SendNotificationResponseType.class, SendNotificationResultType.class);
        } catch (JAXBException e) {
            throw ExceptionUtils.translate(e);
        }
    }

    public static Document marshalResult(SendNotificationResultType result) throws Exception {
        Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        jaxbContext.createMarshaller().marshal(
                new JAXBElement<SendNotificationResultType>(new QName("http://schemas.microsoft.com/exchange/services/2006/messages", "SendNotificationResult"),
                SendNotificationResultType.class, result), document);
        return document;
    }

    public static SendNotificationResponseType unmarshalResponse(Element element) throws Exception {
        JAXBElement<SendNotificationResponseType> unmarshal
                = (JAXBElement<SendNotificationResponseType>) jaxbContext.createUnmarshaller().unmarshal(element);
        return unmarshal.getValue();
    }

    static SendNotificationResultType unmarshalResult(Element element) throws Exception {
        JAXBElement<SendNotificationResultType> unmarshal
                = (JAXBElement<SendNotificationResultType>) jaxbContext.createUnmarshaller().unmarshal(element);
        return unmarshal.getValue();
    }

}
