package ru.yandex.calendar.frontend.ews.hook;

import javax.xml.bind.JAXBElement;

import com.microsoft.schemas.exchange.services._2006.messages.ArrayOfResponseMessagesType;
import com.microsoft.schemas.exchange.services._2006.messages.ResponseMessageType;
import com.microsoft.schemas.exchange.services._2006.messages.SendNotificationResponseMessageType;
import com.microsoft.schemas.exchange.services._2006.messages.SendNotificationResponseType;
import com.microsoft.schemas.exchange.services._2006.messages.SendNotificationResultType;
import com.microsoft.schemas.exchange.services._2006.types.NotificationType;
import com.microsoft.schemas.exchange.services._2006.types.ResponseClassType;
import com.microsoft.schemas.exchange.services._2006.types.SubscriptionStatusType;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.calendar.CalendarRequest;
import ru.yandex.calendar.CalendarRequestHandle;
import ru.yandex.calendar.frontend.ews.EwsUtils;
import ru.yandex.calendar.frontend.ews.YtEwsSubscriptionDao;
import ru.yandex.calendar.logic.event.ActionInfo;
import ru.yandex.calendar.logic.event.ActionSource;
import ru.yandex.calendar.logic.resource.UidOrResourceId;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;

/**
 * @author akirakozov
 */
public class NotificationExchangeWebService {
    private static final Logger logger = LoggerFactory.getLogger(NotificationExchangeWebService.class);
    @Autowired
    private EwsNotificationEventHandler ewsNotificationEventHandler;
    @Autowired
    private YtEwsSubscriptionDao ytEwsSubscriptionDao;

    private String what(SendNotificationResponseType response) {
        return "response from Exchange";
    }

    public SendNotificationResultType sendNotification(SendNotificationResponseType request) {
        CalendarRequestHandle handle = CalendarRequest.push(ActionSource.EXCHANGE, what(request));
        try {
            return sendNotificationInner(request, handle.getActionInfo());
        } finally {
            handle.popSafely();
        }
    }

    private SendNotificationResultType sendNotificationInner(SendNotificationResponseType request, ActionInfo actionInfo) {
        ArrayOfResponseMessagesType responseMessages = request.getResponseMessages();
        ListF<JAXBElement<? extends ResponseMessageType>> responses = null;
        responses = Cf.x(responseMessages.getCreateItemResponseMessageOrDeleteItemResponseMessageOrGetItemResponseMessage());
        for (JAXBElement<? extends ResponseMessageType> response : responses) {
            SendNotificationResponseMessageType snrmt = (SendNotificationResponseMessageType) response.getValue();
            if (!snrmt.getResponseClass().equals(ResponseClassType.SUCCESS)) {
                logger.debug("Response is not successful!");
                continue;
            }
            NotificationType notification = snrmt.getNotification();
            String subscriptionId = notification.getSubscriptionId();
            Option<UidOrResourceId> subjectIdO = ytEwsSubscriptionDao.findSubscriptionByExchangeId(
                    subscriptionId).map(EwsUtils.getSubjectIdF());
            if (subjectIdO.isPresent()) {
                UidOrResourceId subjectId = subjectIdO.get();
                ytEwsSubscriptionDao.updateSubscriptionLastPingTs(subscriptionId);
                ewsNotificationEventHandler.handle(subjectId, notification, actionInfo);
            } else {
                logger.debug(
                        "Exchange subscription wasn't found, subscription_id = " + subscriptionId + ". " +
                        "Unsubscribe result status is being sent...");
                return createResultStatus(false);
            } // subscriber uid was found
        } // for responses
        return createResultStatus(true);
    }

    private SendNotificationResultType createResultStatus(boolean successful) {
        SendNotificationResultType result = new SendNotificationResultType();
        result.setSubscriptionStatus(
                successful ? SubscriptionStatusType.OK : SubscriptionStatusType.UNSUBSCRIBE);
        return result;
    }
}
