package ru.yandex.calendar.frontend.ews.hook;

import java.io.InputStream;

import javax.xml.namespace.QName;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFactory;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import ru.yandex.misc.ExceptionUtils;

/**
 * @author gutman
 */
public class SoapXmlizer {

    private static final String SOAP_NS = "http://schemas.xmlsoap.org/soap/envelope/";

    static final QName ENVELOPE_QNAME = new QName(SOAP_NS, "Envelope", "soap");

    private static final MessageFactory messageFactory;
    private static final SOAPFactory soapFactory;
    static {
        try {
            messageFactory = MessageFactory.newInstance();
            soapFactory = SOAPFactory.newInstance();
        } catch (SOAPException e) {
            throw ExceptionUtils.translate(e);
        }
    }

    public static Element parseSoapRequest(InputStream in) throws Exception {
        return messageFactory.createMessage(new MimeHeaders(), in).getSOAPBody()
                .extractContentAsDocument().getDocumentElement();
    }

    public static Element serializeSoapResponse(Document content) throws Exception {
        SOAPEnvelope envelope = (SOAPEnvelope) soapFactory.createElement(ENVELOPE_QNAME);
        SOAPBody body = envelope.addBody();
        body.addDocument(content);
        return envelope;
    }

}
